PSCAD 4.2.0

Settings
 {
 Id = "917139984.1144363109"
 Author = "reform.jayas"
 Desc = "3D Plotting from Matlab"
 Arch = "windows"
 Options = 8
 Build = 20
 Warn = 1
 Check = 7
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "Untitled.out"
  SFile = "transformer.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  freq = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("RunTime")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,White)
   Rectangle(-29,-12,29,12)
   Text(0,27,"%:Name")
   Text(0,42,"%:Desc")
   }


  Page(A/A4,Landscape,48,[597,467],100)
   {
   }
  }
 Component("Matlab_t_d_plot")
  {
  Desc = ""
  FileDate = 0
  Parameters = 
   {
   Category("Configuration")
    {
    Text("Name",6,2,242,12,2)
     {
     Desc = "Matlab Module Name"
     Def = "t_d_plot"
     Len = 20
     }
    Text("Path",6,16,242,12,2)
     {
     Desc = "Relative path of .m Files"
     Def = "mfiles"
     Len = 20
     }
    Input("Enabl",6,32,242,12,6)
     {
     Desc = "Enable=1 , Disable=0"
     Def = "1"
     Data = Real
     Len = 15
     Min = 0
     Max = 1
     }
    }
   }

  Nodes = 
   {
   Input("INPUT",-72,0)
    {
    Type = Real
    Dim  = [3]
    }
   Output("OUTPUT",72,0)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-45,-15,45,15)
   Line(-72,0,-45,0)
   Line(72,0,45,0)
   Line(-55,-3,-61,3)
   Text(-58,-1,"3")
   Text(0,6,"%Name")
   Text(-1,31,"New Matlab Interface")
   Line(61,0,54,4)
   Line(54,-4,61,0)
   Line(-45,0,-52,4)
   Line(-52,-4,-45,0)
   }

  Section(EMTDC)
   {
   Dsdyn = "\
#STORAGE REAL:4
! --------------------------------------------------
! --------------------------------------------------
! PSCAD/EMTDC - MATLAB INTERFACE
! Module: $Name
#LOCAL INTEGER I_CNT
      IF($Enabl.GT.0.9) THEN
! --------------------------------------------------
! Transfer EMTDC Input Variables to Matlab Interface
! --------------------------------------------------
!
! First Input Array (REAL(3))
       I_CNT = 1
       DO WHILE ( I_CNT .LE. 3 )
          STORF(NSTORF+I_CNT-1) = $INPUT(I_CNT)
          I_CNT = I_CNT + 1
       END DO
!
! --------------------------------------------------
! Call PSCAD/EMTDC Matlab Interface:
! CALL MLAB_INT(\"MFILEPATH\",\"MFILENAME\",\"Input Format\",\"Output Format\")
! --------------------------------------------------
       CALL MLAB_INT(\"%:Dir\\$Path\", \"$Name\", \"R(3)\" , \"R\" )
!
! --------------------------------------------------
! Transfer Matlab Output Variables from Matlab Interface
! --------------------------------------------------
!
! First Output Array (REAL(1))
       $OUTPUT = STORF(NSTORF+3)
      ENDIF
! Update STORx Pointers
      NSTORF = NSTORF + 3 + 1
! --------------------------------------------------
! --------------------------------------------------"
   Help = "..\\pscad\\matlab\\index.htm"
   }
  }
 Module("Main")
  {
  Desc = " "
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(A/A4,Portrait,48,[597,467],100)
   {
   0.xfmr-2w([216,288],0,0,30)
    {
    Tmva = "100.0 [MVA]"
    f = "$(freq)"
    Xl = "0.10 [pu]"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Ideal = "0"
    Tap = "0"
    View = "2"
    V1 = "230 [kV]"
    V2 = "230.0 [kV]"
    Enab = "1"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1. [pu]"
    Txk = "0 [s]"
    Im1 = "1.0 [%]"
    IL1 = ""
    IL2 = ""
    IMAG = "Im"
    FLUX = "Flux"
    }
   0.source1([108,288],1,0,10)
    {
    Name = "sss"
    Type = "1"
    Ctrl = "0"
    Vm = "132.79056 [kV]"
    F = "$(freq)"
    Tc = "0.0 [s]"
    Imp = "0"
    ACDC = "0"
    Exph = "0"
    Term = "0"
    Es = "200 [kV]"
    F0 = "$(freq)"
    Ph = "0.0 [deg]"
    Pac = "0.0 [MW]"
    Qac = "0.0 [MVAR]"
    Esd = "100.0 [kV]"
    Pdc = "0.0 [MW]"
    R1s = "10.0 [ohm]"
    R1p = "1.0 [ohm]"
    L1p = "0.1 [H]"
    Z1 = "1.0 [ohm]"
    Phi1 = "80.0 [deg]"
    RN = "2.0"
    Ia = "Ia"
    }
   -Wire-([108,252],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([180,288],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.ground([108,324],1,0,-1)
    {
    }
   0.ground([180,324],1,0,-1)
    {
    }
   0.ground([252,324],1,0,-1)
    {
    }
   0.resistor([288,324],3,0,-1)
    {
    R = "1e6 [ohm]"
    }
   -Wire-([252,288],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([252,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([180,540],0,0,-1)
    {
    Name = "Im"
    }
   0.pgb([216,540],0,23839312,50)
    {
    Name = "Im"
    Group = "Magnetizing Current"
    Display = "1"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.4"
    Max = "0.2"
    }
   -Wire-([216,540],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.datalabel([270,540],0,0,-1)
    {
    Name = "Flux"
    }
   0.pgb([306,540],0,46381584,60)
    {
    Name = "Flux"
    Group = "Flux Linkage"
    Display = "1"
    Scale = "1.0"
    Units = "kWb-N"
    mrun = "0"
    Pol = "0"
    Min = "-0.5"
    Max = "1.5"
    }
   -Wire-([270,540],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([126,648],2,0,-1)
    {
    Name = "Im"
    }
   0.datalabel([108,666],2,0,-1)
    {
    Name = "Flux"
    }
   0.pgb([324,702],0,24581760,170)
    {
    Name = "out"
    Group = "Matlab"
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.voltmeter([180,288],0,0,20)
    {
    Name = "V1"
    }
   0.impulse([684,1008],0,0,100)
    {
    F = "4000 [Hz]"
    Start = "0 [s]"
    Mag = "1"
    Cnfg = "0"
    INTR = "0"
    }
   -Wire-([756,1008],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.logic([828,1008],0,0,140)
    {
    Type = "2"
    Inv = "0"
    }
   0.var_switch([720,1044],0,46253816,120)
    {
    Name = "Cont. CLK"
    Group = "Matlab"
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.logic([900,972],0,0,150)
    {
    Type = "1"
    Inv = "0"
    }
   0.datalabel([936,972],2,0,-1)
    {
    Name = "Clk"
    }
   0.var_switch([792,972],0,43296248,80)
    {
    Name = "Enab/Disab"
    Group = "Matlab"
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "Enab"
    Toff = "Disab"
    }
   0.datalabel([108,630],2,0,-1)
    {
    Name = "V1"
    }
   -ControlPanel-([666,1098],0)
    {
    Name = "Matlab Cntrl - 2"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 666,1098
    Extents = 0,0,72,126
    Switch(46253816)
    }
   -Sticky-([72,396],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 72,396,342,486
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Transformer with saturation:
  -  primary voltage 230kV
  -  secondary voltage 230kV
  -  knee point 1.0 pu
  -  air core reactance 0.2 pu"
    }
   -Sticky-([198,612],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 198,612,342,648
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Component representing interface to MATLAB."
    }
   -Sticky-([936,846],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 936,846,1188,936
    Alignment = 0
    Style = 1
    Arrow = 64
    Color = 0,15792890
    Text = "\
Variable 'CLK' which controls if a MATLAB function is called at present time step
  - value of '0' - MATLAB function is not called
  - value of '1' - MATLAB function is called"
    }
   -Sticky-([774,846],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 774,846,900,900
    Alignment = 0
    Style = 1
    Arrow = 6
    Color = 0,15792890
    Text = "\
Control of MATLAB
 - 0 - disable
 - 1 - enable"
    }
   -Sticky-([810,1098],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 810,1098,1152,1206
    Alignment = 0
    Style = 1
    Arrow = 20
    Color = 0,15792890
    Text = "\
Control how often a MATLAB function is called (when MATLAB is enabled)
 - 0 - based on impulse generator
 - 1 - every time step"
    }
   0.datalabel([90,540],0,0,-1)
    {
    Name = "V1"
    }
   0.pgb([126,540],0,24237712,40)
    {
    Name = "V1"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   -Wire-([90,540],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -ControlPanel-([666,846],0)
    {
    Name = "Matlab Cntrl - 1"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 666,846
    Extents = 0,0,72,126
    Switch(43296248)
    }
   0.datamerge([162,702],4,0,70)
    {
    N = "3"
    Type = "2"
    Disp = "1"
    }
   -Wire-([108,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([108,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([126,648],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([162,702],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   .Matlab_t_d_plot([252,702],0,0,160)
    {
    Name = "t_d_plot"
    Path = "mfiles"
    Enabl = "Clk"
    }
   -Sticky-([432,270],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 432,270,522,342
    Alignment = 1
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "\
This is a MATLAB m-file.
Double click to see it.
"
    }
   -SrcFile-([342,288],0)
    {
   Name = "mfiles\\t_d_plot.m"
    }
   -Sticky-([72,774],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 72,774,432,1134
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
A T_D_PLOT component. 

It provides the interface to a MATLAB function 't_d_plot'. It is a user-defined  function and the m-file 'T_D_plot.m' contains its definition. This component plots a 3-dimensional curve.

Input: X, Y and Z values of the point to be plot

Output: a dummy output of value zero

Parameters of T_D_PLOT component. 

 - Matlab Module Name
[ name of the .m file ]
 - Relative Path of .m files   
[ it defines the path to a directory, which contains m-file used by the component ]
 - Enable=1, Disable=0
[ it controls if, and how often, a MATLAB function is called:
   0 - function is not called in present time step
   1 - function is called in present time step ]


"
    }
   -Sticky-([486,954],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 486,954,612,1062
    Alignment = 1
    Style = 1
    Arrow = 8
    Color = 0,15792890
    Text = "Impulse generator. Its frequency controls how often a MATLAB function is called."
    }
   -Sticky-([54,90],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 54,90,504,180
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
WARNING
* This case only works if you use the Digital/Compaq/Intel F90 Fortran Compiler."
    }
   -Sticky-([72,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 72,18,1152,54
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "3D PLOT USING MATLAB"
    }
   -Plot-([612,90],0)
    {
    Title = ""
    Draw = 1
    Area = [0,0,522,702]
    Posn = [612,90]
    Icon = [-1,-1]
    Extents = 0,0,522,702
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,522,213],"Voltage")
     {
     Options = 0
     Units = "kV"
     Curve(24237712,"V1",0,,,)
     }
    Graph([0,213],[0,0,522,213],"Magnetizing Current")
     {
     Options = 0
     Units = "kA"
     Curve(23839312,"Im",0,,,)
     }
    Graph([0,426],[0,0,522,213],"Flux Linkage ")
     {
     Options = 0
     Units = "kWb-N"
     Curve(46381584,"Flux",0,,,)
     }
    }
   0.unity([756,1008],0,0,110)
    {
    IType = "2"
    OType = "1"
    }
   0.unity([864,972],0,0,90)
    {
    IType = "2"
    OType = "1"
    }
   0.unity([792,1044],0,0,130)
    {
    IType = "2"
    OType = "1"
    }
   }
  }
 }

